/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import sun.security.ssl.InputRecord;
import sun.security.ssl.SSLSocketImpl;

class AppInputStream
extends InputStream {
    private static final byte[] SKIP_ARRAY = new byte[1024];
    private SSLSocketImpl c;
    InputRecord r;
    private final byte[] oneByte = new byte[1];

    AppInputStream(SSLSocketImpl sSLSocketImpl) {
        this.r = new InputRecord();
        this.c = sSLSocketImpl;
    }

    @Override
    public int available() throws IOException {
        if (this.c.checkEOF() || !this.r.isAppDataValid()) {
            return 0;
        }
        return this.r.available();
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.read(this.oneByte, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.c.checkEOF()) {
            return -1;
        }
        try {
            while (this.r.available() == 0) {
                this.c.readDataRecord(this.r);
                if (!this.c.checkEOF()) continue;
                return -1;
            }
            int n3 = Math.min(n2, this.r.available());
            n3 = this.r.read(byArray, n, n3);
            return n3;
        }
        catch (Exception exception) {
            this.c.handleException(exception);
            return -1;
        }
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        int n;
        int n2;
        long l2 = 0L;
        while (l > 0L && (n2 = this.read(SKIP_ARRAY, 0, n = (int)Math.min(l, (long)SKIP_ARRAY.length))) > 0) {
            l -= (long)n2;
            l2 += (long)n2;
        }
        return l2;
    }

    @Override
    public void close() throws IOException {
        this.c.close();
    }
}

