/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;

class OutputRecord
extends ByteArrayOutputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    private boolean firstMessage = true;
    private final byte contentType;
    private int headerOffset;
    ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private ProtocolVersion helloVersion = ProtocolVersion.DEFAULT_HELLO;
    static final Debug debug = Debug.getInstance("ssl");
    private static int[] V3toV2CipherMap1 = new int[]{-1, -1, -1, 2, 1, -1, 4, 5, -1, 6, 7};
    private static int[] V3toV2CipherMap3 = new int[]{-1, -1, -1, 128, 128, -1, 128, 128, -1, 64, 192};

    OutputRecord(byte by, int n) {
        super(n);
        this.count = 261;
        this.contentType = by;
        this.lastHashed = this.count;
        this.headerOffset = 256;
    }

    OutputRecord(byte by) {
        this(by, OutputRecord.recordSize(by));
    }

    private static int recordSize(byte by) {
        if (by == 20 || by == 21) {
            return 539;
        }
        return 16921;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    synchronized void setHelloVersion(ProtocolVersion protocolVersion) {
        this.helloVersion = protocolVersion;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.lastHashed = this.count = 261;
        this.headerOffset = 256;
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        assert (this.contentType == 22);
        this.handshakeHash = handshakeHash;
    }

    void doHashes() {
        int n = this.count - this.lastHashed;
        if (n > 0) {
            this.hashInternal(this.buf, this.lastHashed, n);
            this.lastHashed = this.count;
        }
    }

    private void hashInternal(byte[] byArray, int n, int n2) {
        if (debug != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[write] MD5 and SHA1 hashes:  len = " + n2);
                hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, this.lastHashed, n2), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.handshakeHash.update(byArray, this.lastHashed, n2);
        this.lastHashed = this.count;
    }

    boolean isEmpty() {
        return this.count == 261;
    }

    boolean isAlert(byte by) {
        if (this.count > 262 && this.contentType == 21) {
            return this.buf[262] == by;
        }
        return false;
    }

    void encrypt(Authenticator authenticator, CipherBox cipherBox) throws IOException {
        Object object;
        if (this.contentType == 22) {
            this.doHashes();
        }
        if (authenticator instanceof MAC && ((MAC)(object = (MAC)authenticator)).MAClen() != 0) {
            byte[] byArray = ((MAC)object).compute(this.contentType, this.buf, 261, this.count - 261, false);
            this.write(byArray);
        }
        if (!cipherBox.isNullCipher()) {
            if (this.protocolVersion.v >= ProtocolVersion.TLS11.v && (cipherBox.isCBCMode() || cipherBox.isAEADMode())) {
                object = cipherBox.createExplicitNonce(authenticator, this.contentType, this.count - 261);
                int n = 261 - ((Object)object).length;
                System.arraycopy(object, 0, this.buf, n, ((Object)object).length);
                this.headerOffset = n - 5;
            } else {
                this.headerOffset = 256;
            }
            int n = 261;
            if (!cipherBox.isAEADMode()) {
                n = this.headerOffset + 5;
            }
            this.count = n + cipherBox.encrypt(this.buf, n, this.count - n);
        }
    }

    final int availableDataBytes() {
        int n = this.count - 261;
        return 16384 - n;
    }

    private void ensureCapacity(int n) {
        if (n > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, n);
        }
    }

    final byte contentType() {
        return this.contentType;
    }

    void write(OutputStream outputStream, boolean bl, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (this.count == 261) {
            return;
        }
        int n = this.count - this.headerOffset - 5;
        if (n < 0) {
            throw new SSLException("output record size too small: " + n);
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake")) && (debug != null && Debug.isOn("record") || this.contentType() == 20)) {
            System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + n);
        }
        if (this.firstMessage && this.useV2Hello()) {
            byte[] byArray = new byte[n - 4];
            System.arraycopy(this.buf, 265, byArray, 0, byArray.length);
            this.headerOffset = 0;
            this.V3toV2ClientHello(byArray);
            this.handshakeHash.reset();
            this.lastHashed = 2;
            this.doHashes();
            if (debug != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", WRITE: SSLv2 client hello message, length = " + (this.count - 2));
            }
        } else {
            this.buf[this.headerOffset + 0] = this.contentType;
            this.buf[this.headerOffset + 1] = this.protocolVersion.major;
            this.buf[this.headerOffset + 2] = this.protocolVersion.minor;
            this.buf[this.headerOffset + 3] = (byte)(n >> 8);
            this.buf[this.headerOffset + 4] = (byte)n;
        }
        this.firstMessage = false;
        int n2 = 0;
        if (bl) {
            this.writeBuffer(byteArrayOutputStream, this.buf, this.headerOffset, this.count - this.headerOffset, n2);
        } else {
            if (byteArrayOutputStream != null && byteArrayOutputStream.size() > 0) {
                int n3 = byteArrayOutputStream.size();
                int n4 = this.count + n3 - this.headerOffset;
                this.ensureCapacity(n4);
                System.arraycopy(this.buf, this.headerOffset, this.buf, n3, this.count - this.headerOffset);
                System.arraycopy(byteArrayOutputStream.toByteArray(), 0, this.buf, 0, n3);
                this.count = n4;
                this.headerOffset = 0;
                byteArrayOutputStream.reset();
                n2 = n3;
            }
            this.writeBuffer(outputStream, this.buf, this.headerOffset, this.count - this.headerOffset, n2);
        }
        this.reset();
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        outputStream.write(byArray, n, n2);
        outputStream.flush();
        if (debug != null && Debug.isOn("packet")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[Raw write]: length = " + (n2 - n3));
                hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n + n3, n2 - n3), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean useV2Hello() {
        return this.firstMessage && this.helloVersion == ProtocolVersion.SSL20Hello && this.contentType == 22 && this.buf[this.headerOffset + 5] == 1 && this.buf[299] == 0;
    }

    private void V3toV2ClientHello(byte[] byArray) throws SSLException {
        int n = 34;
        byte by = byArray[n];
        int n2 = n + 1 + by;
        int n3 = ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
        int n4 = n3 / 2;
        int n5 = n2 + 2;
        int n6 = 0;
        this.count = 11;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            byte by2 = byArray[n5++];
            byte by3 = byArray[n5++];
            n6 += this.V3toV2CipherSuite(by2, by3);
            if (bl || by2 != 0 || by3 != -1) continue;
            bl = true;
        }
        if (!bl) {
            n6 += this.V3toV2CipherSuite((byte)0, (byte)-1);
        }
        this.buf[2] = 1;
        this.buf[3] = byArray[0];
        this.buf[4] = byArray[1];
        this.buf[5] = (byte)(n6 >>> 8);
        this.buf[6] = (byte)n6;
        this.buf[7] = 0;
        this.buf[8] = 0;
        this.buf[9] = 0;
        this.buf[10] = 32;
        System.arraycopy(byArray, 2, this.buf, this.count, 32);
        this.count += 32;
        this.count -= 2;
        this.buf[0] = (byte)(this.count >>> 8);
        this.buf[0] = (byte)(this.buf[0] | 0x80);
        this.buf[1] = (byte)this.count;
        this.count += 2;
    }

    private int V3toV2CipherSuite(byte by, byte by2) {
        this.buf[this.count++] = 0;
        this.buf[this.count++] = by;
        this.buf[this.count++] = by2;
        if ((by2 & 0xFF) > 10 || V3toV2CipherMap1[by2] == -1) {
            return 3;
        }
        this.buf[this.count++] = (byte)V3toV2CipherMap1[by2];
        this.buf[this.count++] = 0;
        this.buf[this.count++] = (byte)V3toV2CipherMap3[by2];
        return 6;
    }
}

