/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.keytool;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import sun.security.pkcs10.PKCS10;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import sun.security.x509.X509Key;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public CertAndKeyGen(String string, String string2) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(string);
        this.sigAlg = string2;
    }

    public CertAndKeyGen(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string3 == null) {
            this.keyGen = KeyPairGenerator.getInstance(string);
        } else {
            try {
                this.keyGen = KeyPairGenerator.getInstance(string, string3);
            }
            catch (Exception exception) {
                this.keyGen = KeyPairGenerator.getInstance(string);
            }
        }
        this.sigAlg = string2;
    }

    public void setRandom(SecureRandom secureRandom) {
        this.prng = secureRandom;
    }

    public void generate(int n) throws InvalidKeyException {
        KeyPair keyPair;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(n, this.prng);
            keyPair = this.keyGen.generateKeyPair();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        if (!"X.509".equalsIgnoreCase(this.publicKey.getFormat())) {
            throw new IllegalArgumentException("publicKey's is not X.509, but " + this.publicKey.getFormat());
        }
    }

    public X509Key getPublicKey() {
        if (!(this.publicKey instanceof X509Key)) {
            return null;
        }
        return (X509Key)this.publicKey;
    }

    public PublicKey getPublicKeyAnyway() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, Date date, long l) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(x500Name, date, l, null);
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, Date date, long l, CertificateExtensions certificateExtensions) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Date date2 = new Date();
            date2.setTime(date.getTime() + l * 1000L);
            CertificateValidity certificateValidity = new CertificateValidity(date, date2);
            X509CertInfo x509CertInfo = new X509CertInfo();
            x509CertInfo.set("version", new CertificateVersion(2));
            x509CertInfo.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
            AlgorithmId algorithmId = AlgorithmId.get(this.sigAlg);
            x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", x500Name);
            x509CertInfo.set("key", new CertificateX509Key(this.publicKey));
            x509CertInfo.set("validity", certificateValidity);
            x509CertInfo.set("issuer", x500Name);
            if (certificateExtensions != null) {
                x509CertInfo.set("extensions", certificateExtensions);
            }
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(this.privateKey, this.sigAlg);
            return x509CertImpl;
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("getSelfCert: " + iOException.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, long l) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(x500Name, new Date(), l);
    }

    public PKCS10 getCertRequest(X500Name x500Name) throws InvalidKeyException, SignatureException {
        PKCS10 pKCS10 = new PKCS10(this.publicKey);
        try {
            Signature signature = Signature.getInstance(this.sigAlg);
            signature.initSign(this.privateKey);
            pKCS10.encodeAndSign(x500Name, signature);
        }
        catch (CertificateException certificateException) {
            throw new SignatureException(this.sigAlg + " CertificateException");
        }
        catch (IOException iOException) {
            throw new SignatureException(this.sigAlg + " IOException");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(this.sigAlg + " unavailable?");
        }
        return pKCS10;
    }
}

