/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKeyGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.SecretKey;

final class DESKey
implements SecretKey {
    static final long serialVersionUID = 7724971015953279128L;
    private byte[] key;

    DESKey(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    DESKey(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null || byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
        DESKeyGenerator.setParityBit(this.key, 0);
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return "DES";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        return n ^= "des".hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!string.equalsIgnoreCase("DES")) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        boolean bl = MessageDigest.isEqual(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

